//#-hidden-code
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import PlaygroundSupport
import Setup
import Canvas
import Scenes
import UIKit
import SpriteKit
import SwansQuest

PlaygroundPage.current.liveView = PlaygroundContext.liveViewController
PlaygroundContext.liveViewController.backgroundImage = #imageLiteral(resourceName: "LiveViewBackground.png")

Canvas.load(customFont: "Songkhla-Regular")

let cave = Cave()


let passages = [
    "Curious traveler, welcome. You must seek great knowledge to take such a treacherous journey through the dark cave.",
    
    "You are clearly talented with code, and have been well trained with VoiceOver. I commend you on making it this far.",
    
    "Do you have the desire for more adventure, and an even greater challenge?\n\nIf so, I present you with this ancient scroll from my ancestors.",
    
    "Study this scroll, traveler. These are your first clues to unlocking new worlds. This knowledge is older than this palace. A gift from nature itself.",
    
    "I’ll await your return."
]

let script = Script(passages, success: "You‘ve lit the way!", tryAgain: "You‘re still in the dark, adventurer.")

let clue = "261.63, 293.66,\n329.63, 349.23,\n392.00, 440.00,\n493.88, 523.25"

let conversation = Conversation(with: .swan, using: script)
conversation.scrollAppearsAtIndex = (2, .custom(text: clue))


cave.loadingDescription = "You've stumbled into a dark and dreary cave. Feel around to search for torches that you can light."

let hallEntrance = HallEntrance()
hallEntrance.loadingDescription = "At the end of the cave, our hero finds a staircase leading to a magnificent purple room. It's the hall of the Swan! Cautious, our Hero leaps the stairs and walks into the hall..."

let hallComing = Hall(heroIs: .coming)
hallComing.loadingDescription = "Flickering candelabras and tapestries of past bird regents adorn the purple-clad walls. Our Hero approaches the throne, where a snow-white swan eagerly awaits their visitor."

conversation.loadingDescription = "The Swan speaks to the Turtle, their voice booming in the vast hall."

let hallLeaving = Hall(heroIs: .leaving)
hallLeaving.loadingDescription = "A challenge? Our Hero takes the scroll and turns to leave. They swear they saw a smirk form on the Swan's beak as they turned. What could the numbers mean? Our Hero knows where to go next. The Lizard was right about the Swan, and will how to help with the challenge."

let endTitle = TextScene(says: "To be continued...")
endTitle.loadingDescription = "The story continues in Chapter 2 of Swan's Quest. Until next time..."

var runner = Runner([ cave, hallEntrance, hallComing, conversation, hallLeaving, endTitle ])

runner.start()

//#-end-hidden-code
//#-editable-code
// Touch "Run My Code" to continue your quest...
// Add accessibility hints to torches here
// Example: cave.torch1.accessibilityHints?.accessibilityLabel = "Helpful hint"

//#-end-editable-code
